#include_next <linux/slab.h>

#include_next <linux/slab.h>

#ifndef BACKPORT_LINUX_STRING_TO_2_6_18
#define BACKPORT_LINUX_STRING_TO_2_6_18

static inline
void *kmemdup(const void *src, size_t len, gfp_t gfp)
{
       void *p;

       p = kmalloc(len, gfp);
       if (p)
               memcpy(p, src, len);
       return p;
}

#endif
#ifndef BACKPORT_LINUX_STRING_TO_2_6_18
#define BACKPORT_LINUX_STRING_TO_2_6_18

static inline
void *kmemdup(const void *src, size_t len, gfp_t gfp)
{
       void *p;

       p = kmalloc(len, gfp);
       if (p)
               memcpy(p, src, len);
       return p;
}

#endif
#ifndef SLAB_H_KMEMCACHE_ZALLOC_BACKPORT_TO_2_6_16
#define SLAB_H_KMEMCACHE_ZALLOC_BACKPORT_TO_2_6_16

static inline
void *kmem_cache_zalloc(struct kmem_cache *cache, gfp_t flags)
{
       void *ret = kmem_cache_alloc(cache, flags);
       if (ret)
	       memset(ret, 0, kmem_cache_size(cache));

       return ret;
}

#endif
